﻿Partial Public Class MainPage
    Inherits PhoneApplicationPage
    Public Sub New()
        InitializeComponent()
    End Sub


    Protected Overrides Sub OnManipulationStarted(ByVal args As ManipulationStartedEventArgs)
        If args.OriginalSource Is pt0Dragger OrElse
            args.OriginalSource Is pt1Dragger OrElse
            args.OriginalSource Is pt2Dragger Then

            args.ManipulationContainer = ContentPanel
            args.Handled = True
        End If
        MyBase.OnManipulationStarted(args)
    End Sub


    Protected Overrides Sub OnManipulationDelta(ByVal args As ManipulationDeltaEventArgs)
        Dim translate = args.DeltaManipulation.Translation

        If args.OriginalSource Is pt0Dragger Then
            pathFig.StartPoint = Move(pathFig.StartPoint, translate)
            ctrlLine.Points(0) = Move(ctrlLine.Points(0), translate)
            pt0Ellipse.Center = Move(pt0Ellipse.Center, translate)
            args.Handled = True
        ElseIf args.OriginalSource Is pt1Dragger Then
            pathSeg.Point1 = Move(pathSeg.Point1, translate)
            ctrlLine.Points(1) = Move(ctrlLine.Points(1), translate)
            pt1Ellipse.Center = Move(pt1Ellipse.Center, translate)
            args.Handled = True
        ElseIf args.OriginalSource Is pt2Dragger Then
            pathSeg.Point2 = Move(pathSeg.Point2, translate)
            ctrlLine.Points(2) = Move(ctrlLine.Points(2), translate)
            pt2Ellipse.Center = Move(pt2Ellipse.Center, translate)
            args.Handled = True
        End If

        MyBase.OnManipulationDelta(args)
    End Sub


    Private Function Move(ByVal point As Point, ByVal translate As Point) As Point
        Return New Point(point.X + translate.X, point.Y + translate.Y)
    End Function
End Class

